/*==============================================================================
Harassment 101.

This uses the LlamaMessages to display random messages when players get a
headshot on another player (or when bots headshot players), Perfect Strings
display when a player with over "PerfectScore" kills and 0 deaths is shot,
and also there are 10 Taunt strings that you can play for players that use a
certain name.

Written by Christopher "CPanoplyd" Doyle
cpanoplyd@comcast.net

Use 'mutate hs debug' or !hsdebug to toggle test mode to play HEADSHOT or PERFECT
messages for any shot.
==============================================================================*/
class MutHarassment expands Mutator config(HarassmentConfig);

var bool bInitialized, bTeamGame, bTourney, bDebug;

var HSMedia HSM;
var float PlayNext;

var HSNotify HSR;
var int iLlamas, iPerfects, iTaunts;

var config bool bTaunts;
var config int PerfectScore;

event PreBeginPlay()
{
	local int i,j;

	HSM=spawn(class'HSMedia');
	HSM.LoadSounds();

	HSR = spawn(class'HSNotify');

	if ( HSM.ClanTag != "" )
		HSR.ClanTag = HSM.ClanTag;

	HSR.HeadShotColor = HSM.HeadShotColor;
	HSR.PerfectColor = HSM.PerfectColor;
	HSR.TauntColor = HSM.TauntColor;
	j=0;
	for(i=0; i<arraycount(HSM.HeadshotMessages);i++)
	{
		if (HSM.HeadshotMessages[i] != "" )
		{
			HSR.HeadshotMessage[i] = HSM.HeadshotMessages[i];
			j++;
		}
		else break;
	}
	iLlamas = j;
	j=0;
	for(i=0; i<arraycount(HSM.PerfectMessages);i++)
	{
		if (HSM.PerfectMessages[i] != "" )
		{
			HSR.PerfectMessage[i] = HSM.PerfectMessages[i];
			j++;
		}
		else break;
	}
	iPerfects = j;
	j=0;
	for(i=0; i<arraycount(HSM.TauntMessages);i++)
	{
		if ( ( HSM.TauntMessages[i].PlayerName != "" ) && ( HSM.TauntMessages[i].TauntMessage != "" ) )
		{
			HSR.TauntMessage[i] = HSM.TauntMessages[i].TauntMessage;
			j++;
		}
		else break;
	}
	iTaunts = j;
}

function PostBeginPlay()
{
	if (bInitialized)
		return;
	bInitialized = True;

	Level.Game.RegisterDamageMutator( self );
	Level.Game.RegisterMessageMutator( self );

	if(level.Game.IsA('TeamGame') || level.Game.IsA('TeamGamePlus'))
		bTeamGame=true;

    	if ( DeathMatchPlus(Level.Game).bTournament == True )
		bTourney = true;
	else
		bTourney = false;
}

function bool PreventDeath( Pawn Victim, Pawn InstigatedBy,
		name damageType, vector HitLocation )
{
	local int i;
	local HSReplication HSRep;

	if ( bDebug )
	{
		if ( DamageType != 'fell' )
		{
			if ( DamageType != 'Decapitated' ) //	PERFECT STRINGS AND SOUNDS
			{
				BroadcastLocalizedMessage(class'HSMessage',rand(iPerfects)+50, InstigatedBy.PlayerReplicationInfo, victim.PlayerReplicationInfo);
				PlayMedia( 0, rand( HSM.sndPerfectSize ) );
			}
			else	//	HEADSHOT STRINGS
			{
				BroadcastLocalizedMessage(class'HSMessage', rand(iLlamas), InstigatedBy.PlayerReplicationInfo, victim.PlayerReplicationInfo);
				PlayMedia( 1, rand( HSM.sndHeadShotSize ) );
			}
			return false;
		}
	}
	else
	{
		//	PERFECT STRINGS AND SOUNDS
		if ( ( Victim.PlayerReplicationInfo.Deaths == 0 && ( Victim.PlayerReplicationInfo.Score >= PerfectScore ) )
			&& ( InstigatedBy != none && !victim.IsA('Bot') ) )
		{
			BroadcastLocalizedMessage(class'HSMessage',rand(iPerfects)+50,InstigatedBy.PlayerReplicationInfo, victim.PlayerReplicationInfo);
			PlayMedia( 0, rand( HSM.sndPerfectSize ) );
			return false;
		}
		//	HEADSHOT STRINGS
		if ( DamageType == 'Decapitated' )
		{
			if ( (InstigatedBy.IsA('Bot') && victim.IsA('Bot')   //  Bot vs Bot Kill
			|| (InstigatedBy.IsA('PlayerPawn') && victim.IsA('Bot') ) ) //Player vs Bot Kill
			|| (InstigatedBy.PlayerReplicationInfo.Team == Victim.PlayerReplicationInfo.Team && bTeamGame ) ) // Team Game
				return false;
			else if ( (InstigatedBy.IsA('Bot') && victim.IsA('PlayerPawn') )
			|| ( InstigatedBy.IsA('PlayerPawn') && victim.IsA('PlayerPawn') ) )
			{
				BroadcastLocalizedMessage(class'HSMessage', rand(iLlamas), InstigatedBy.PlayerReplicationInfo, victim.PlayerReplicationInfo);
				PlayMedia( 1, rand( HSM.sndHeadShotSize ) );
				return false;
			}
		}
	}

	if ( bTourney )
		return false; //Hope this works this time!!!
	else if ( bTaunts )
	{
		if ( ( DamageType == 'shot' ) )
		{
			for (i=0; i<iTaunts;i++)
			{
				if ( caps( Victim.PlayerReplicationInfo.PlayerName ) == caps( HSM.TauntMessages[i].PlayerName ) )
					BroadcastLocalizedMessage(class'HSMessage',i+40,InstigatedBy.PlayerReplicationInfo,Victim.PlayerReplicationInfo);
			}
		}
		return false;
	}

	return false;
}

function Mutate(string MutateString, PlayerPawn Sender)
{
	local bool bAdmin;
	local string CommandString, ParameterString;

	bAdmin = Sender.PlayerReplicationInfo.bAdmin;

	if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender);

	if ( ( Caps(MutateString) == "HS" ) )
		     Sender.ClientMessage("Invalid Command.");
	else if ( (Left (Caps (MutateString),3) == "HS " ) )
			CommandString = Mid(MutateString,3);

//var bool DEBUG
	if ( ( Left( Caps (CommandString),5) == "DEBUG" ) )
	{
		if (bAdmin)
		{
			ParameterString = Mid(CommandString,5);
			if ( Left( ParameterString, 2 ) == " ?" )
			{
				if ( bDebug )
					Sender.ClientMessage("Debug is ON!");
				else
					Sender.ClientMessage("Debug is OFF!");
			}
			else
			{
				bDebug = !bDebug;
				BroadcastMessage("Headshot Debug is "$bDebug$"!!");
			}
		}
		else
			BroadcastMessage("Headshot Debug mode is for ADMIN Use Only.");
	}
//var config bool taunts
	if ( ( Left( Caps (CommandString),6) == "TAUNTS" ) )
	{
		if ( bAdmin )
		{
			ParameterString = Mid(CommandString,6);
			if ( Left( ParameterString, 2 ) == " ?" )
			{
				if ( bTaunts )
				{
					Sender.ClientMessage("ALL Taunts are ON!");
					SaveConfig();
				}
				else
					Sender.ClientMessage("ALL Taunts are OFF!");
			}
			else
			{
				bTaunts = !bTaunts;
				BroadcastMessage("Taunts are "$bTaunts$"!!");
				SaveConfig();
			}
		}
		else
			BroadcastMessage("Taunt mode is for ADMIN'S Use Only.");
	}
}

function bool MutatorTeamMessage(Actor Sender, Pawn Receiver, PlayerReplicationInfo PRI, coerce string S, name Type, optional bool bBeep)
{

	if (PRI != None && Receiver != None && Sender.IsA('PlayerPawn'))
	{
		if ( Left( caps(S), 8) ~= "!HSDEBUG" )
		{
			if ( Sender == Receiver )
			{
				if ( Mid(S,9) == "?" )
					PlayerPawn(Sender).ConsoleCommand("MUTATE HS DEBUG ?");
				else
					PlayerPawn(Sender).ConsoleCommand("MUTATE HS DEBUG");
			}
		}
		else if ( Left( caps(S), 8) ~= "!HSTAUNTS" )
		{
			if ( Sender == Receiver )
			{
				if ( Mid(S,10) == "?" )
					PlayerPawn(Sender).ConsoleCommand("MUTATE HS TAUNTS ?");
				else
					PlayerPawn(Sender).ConsoleCommand("MUTATE HS TAUNTS");
			}
		}
	}

	if ( NextMessageMutator != None )
		return NextMessageMutator.MutatorTeamMessage( Sender, Receiver, PRI, S, Type, bBeep );

	return true;
}

//BunnyFooFoo PlayMedia slightly altered for this purpose
// int Type for futher implementation of specific strings with specific sounds
// just use 0 for Perfects, 1 for Headshots in bulk
function PlayMedia(int type, int pSound )
{
	local Pawn P;

	switch (type)
	{
		case 0:
			if ( Level.TimeSeconds >= PlayNext )
			{
				for (P = Level.PawnList; P != None; P = P.NextPawn)
				{
				 	if( !P.IsA('Bot'))
				 	{
						PlayerPawn(P).ClientPlaySound(HSM.sndPerfect[pSound],false,true);
						PlayNext = Level.TimeSeconds + HSM.PerfectDuration[pSound];
					}
				}
			}
			break;
		case 1:
			if ( Level.TimeSeconds >= PlayNext )
			{
				for (P = Level.PawnList; P != None; P = P.NextPawn)
				{
				 	if( !P.IsA('Bot'))
				 	{
						PlayerPawn(P).ClientPlaySound(HSM.sndHeadShot[pSound],false,true);
						PlayNext = Level.TimeSeconds + HSM.HeadShotDuration[pSound];
					}
				}
			}
			break;
	}
}

defaultproperties
{
	bDebug=false
}
